﻿var panelistEditor = {
    page: null,
    context: null,
    groups: [],
    panelistId: 0
}

$(document).ready(function () {
    panelistEditor.page = GetCurrentPagePath();
    panelistEditor.context = $("#PanelistEditor");
    panelistEditor.panelistId = $("#Current_Id", panelistEditor.context).val();
    $("#Current_FirstName").prop("disabled", !hasAccessToPersonalData);
    $("#Current_LastName").prop("disabled", !hasAccessToPersonalData);
    $("#Current_Phone").prop("disabled", !hasAccessToPersonalData);
    $("#Current_Email").prop("disabled", !hasAccessToPersonalData);



    $("#Current_Version", panelistEditor.context).on("change", function () {
        window.location.href = panelistEditor.page + "?panelistId=" + panelistEditor.panelistId + "&version=" + $(this).val();
    });

    if ($("#Current_Version", panelistEditor.context).val() > "0")
    {
        $("input[type=submit]").attr("disabled", "disabled");
    }
    else
    {
        $("input.h-autonumeric").autoNumeric({ aSep: '', aDec: '.', aPad: false });

        var forceDatePickerFormat = $("#Current_ForceAttributeDateFormatToyymmdd", panelistEditor.context).val();
        
        $("input.h-datepicker:not(.panelAttribute)").datepicker();

        if (typeof forceDatePickerFormat !== 'undefined' && forceDatePickerFormat == "True")
            $("input.h-datepicker.panelAttribute").datepicker({ dateFormat: "yymmdd" });
        else
            $("input.h-datepicker.panelAttribute").datepicker();

        $(".h-languageAutocomplete", panelistEditor.context).a4autocomplete({
            ajaxAction: a4.getAction("GetLanguages", "Panelists", "Panel"),
            altValueField: $("#Current_Language")
        });


        $(".h-timezoneAutocomplete", panelistEditor.context).a4autocomplete({
            ajaxAction: a4.getAction("GetTimeZones", "Panelists", "Panel"),
            labelProperty: "Text",
            altValueField: $("#Current_TimeZone")
        });

        $(".h-groupsAutoCompleteContainer").a4autocomplete({
            ajaxAction: a4.getAction("GetGroups", "Panelists", "Panel"),
            select: function (event, data) {
                $("#Current_GroupsJson").val(_.pluck($(this).a4autocomplete("getValue"), "Value"));
            },
            removeItem: function (event, data) {
                $("#Current_GroupsJson").val(_.pluck($(this).a4autocomplete("getValue"), "Value"));
            },
            multipleSelection: true
        });
    }
});

